package org.injac.cocoon.generators;
//*********** imports generator **************************
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.Date;
//import java.util.Calendar;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.Generator;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.generation.DirectoryGenerator.DirValidity;
import org.apache.commons.httpclient.HttpURL;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.Property;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.methods.DepthSupport;
import org.apache.webdav.lib.methods.PropFindMethod;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;
import org.injac.utils.WebdavConnection;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;


/**
 * Generates an XML metadatas listing from a webdav(slide) resource.
 * <p>
 * 
 * <blockquote>
 *  <dl>
 *  <dt> MD:response </dt>
 *  <dd> root element </dd>
 * 	<dt> @directory </dt>
 *  <dd> name of the root directory </dd>
 *  </dl>
 * </blockquote>
 * <blockquote>
 *   <dl>
 *   <dt> MD:resource </dt>
 *   <dd> resource element containing all MD as attributes </dd>
 *   <dt> @name </dt>
 *   <dd> name of the resource </dd>
 *   <dt> @creationdate </dt>
 *   <dd> resource creation date </dd>
 *   <dt> @modificationdate </dt>
 *   <dd> resource last modification date </dd>
 *    <dt> @displayname </dt>
 *   <dd> alternative name for display </dd>
 *   <dt> @resourcetype </dt>
 *   <dd> possible values are D for directory and F for file </dd>
 *   <dt> @source </dt>
 *   <dd> source url </dd>
 *   <dt> @getcontentlength </dt>
 *   <dd> resource size </dd>
 *   <dt> @getcontentlanguage </dt>
 *   <dd> code for resource language ex: en </dd>
 *   <dt> @getcontenttype </dt>
 *   <dd> resource mime type ex : text/xml</dd>
 *   <dt> custom metadatas </dt>
 *   <dd> any metadata defined for a resource</dd>
 *  
 *   </dl>
 * </blockquote>
 * <p>
 * <b>Configuration options:</b>
 * <dl>
 * <dt> <code>src</code></dt>
 * <dd>  sitemap parameter defines the root path to the webdav resource to harvest.</dd>
 * <dt> depht </dt>
 * <dd> depth of the harvest : 0, n, or infinity</dd>
 * </dl>
 * @author <a href="mailto:f.jannin@etu.enseeiht.fr">Franois Jannin</a>
 *         (ENSEEIHT)
 * @version 1.0
 */
public class WebdavGenerator extends ServiceableGenerator implements Generator {
	
    /** The delay between checks on updates to the filesystem. */
    protected long refreshDelay;
    /** The URI of the namespace of this generator. */
    protected static final String URI = "http://esup-portail.org/injac";
    /** Root Node name */
    protected static final String ROOT_NODE_NAME = "response";
    /** The namespace prefix for this namespace. */
    protected static final String PREFIX = "MD";
	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(WebdavGenerator.class);
	/**
	 * Connection with session management
	 */
	private WebdavConnection webdavConnection;
	/**
	 * name of the requested directory
	 */
	private String directory;
	/**
	 * The dav ressource uri
	 */
	private String webdavpath;
	/**
	 * depth of the harvest, by default 1
	 */
	private int depth=DepthSupport.DEPTH_1;
	
	/**
	 * string with md to retrieve separated by a space
	 * TODO Not implemented
	 */
	private String reqparams;
	/**
	 * Credentials
	 */
	private String login;
	private String password;
	/**
	 * Vector with requested MD name
	 */
	private Vector mdVector;
	
	/**
     * -Set the request parameters. Must be called before the generate method.
     * -Stock keys for caching.
     *
     * @param resolver     the SourceResolver object
     * @param objectModel  a <code>Map</code> containing model object
     * @param src          the directory to be XMLized specified as src attribute on &lt;map:generate/>
     * @param par          configuration parameters
     */
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par)
            throws ProcessingException, SAXException, IOException {
        if (src == null) {
            throw new ProcessingException("No src attribute pointing to a Webdav resource whom metadas to be XMLized specified.");
        }
        super.setup(resolver, objectModel, src, par);
        directory= src.substring(src.lastIndexOf('/')+1);
        logger.debug("directory : "+directory);
        
        this.webdavpath = src;	
        webdavConnection = new WebdavConnection(objectModel);
        // 1. get parameters from pipeline
        
        try {
			String SD=par.getParameter("depth");
			
			if(SD.equals("infinity"))
				depth= DepthSupport.DEPTH_INFINITY;
			if(SD.equals("0"))
				depth= DepthSupport.DEPTH_0;
			if(SD.equals("1"))
				depth= DepthSupport.DEPTH_1;
		}catch(Exception e)
		{
			depth= DepthSupport.DEPTH_1;
		}
		logger.debug("DEPTH : "+depth);
        //      Rcupration des credentials
		try {
			login=par.getParameter("login");
			password=par.getParameter("password");
		}
		catch(Exception e)
		{
			login=null;
			password=null;
		}
        // 2. Connect to webdavresource
        try {
			connect(webdavpath);
			logger.debug("WebdavGenerator::setup : connection ressource : "+webdavpath+ " okay");
        }catch(Exception e)
		{
        	logger.error("WebdavGenerator::setup : Can't establish webdav connection : "+webdavpath+"\nCheck either URI is incorrect or login/password error.\n"+e.getMessage());
        	
		}
    
		
    }
    
     void buildResponse()
	{
    	logger.info("WebdavGenerator::buildResponse");
		Enumeration resp_enum=null;
		Enumeration md=null;
		try
		{
			md = webdavConnection.getResponses(webdavpath, depth);
			logger.info("WebdavGenerator::buildResponse propfindMethod ok");
		}catch(Exception e)
		{
			logger.error("WebdavGenerator::buildResponse : propfindMethod error:\npath: "+webdavpath+"\n"+e.getMessage());
			
		}
		
		try
		{
			int i=0;
			logger.debug("WebdavGenerator::buildResponse : PropFind methode ok");           
			while(md.hasMoreElements())
			{
				Object resp_element =md.nextElement();
				logger.debug("class resp_element "+i+" : "+resp_element.getClass());//+" resp_element.toString : "+resp_element.toString());
				XMLResponseMethodBase.Response resp= (XMLResponseMethodBase.Response)resp_element;
				addFileProp(resp);
				i++;
            }
			logger.info("WebdavGenerator::buildResponse parsing elements("+i+" elements) ok");
		}catch (Exception e) {
			logger.error("WebdavGenerator::buildResponse : parsing MD error\n webdavpath :"+webdavpath+"\n"+e.getMessage());
			
		}
	}
    /**
     * Pour une ressource, ajoute un lment au document rponse
     * @param resp
     */
void addFileProp(XMLResponseMethodBase.Response resp){
	logger.debug("WebdavGenerator::addFileProp");
	String nodeName="resource";
	AttributesImpl attributes = new AttributesImpl();
	String href= resp.getHref();
	String value= href.substring(href.lastIndexOf("/")+1);
	// attribut identifiant la resource
	try {
		attributes.addAttribute("","name", "name", "CDATA", value  );
		attributes.addAttribute("","href", "href", "CDATA", href  );
	} catch (Exception e) {
		logger.error("attributes.addAttribute(\"\",\"name\", \"name\", \"CDATA\", "+value+")\n"+e.getMessage());
	}
	
	try
	{
			
		Enumeration properties =resp.getProperties();
	
		//  elements for publication validity checking
		boolean published = true;
		boolean checkdate = true;
		String begin="";
		String end="";
		
		
		while(properties.hasMoreElements())
		{
			Property prop = (Property)properties.nextElement();
			Element el=prop.getElement();
			String tagname =el.getNodeName();
			
			// 	cas o l'lment n'a pas de contenu
			value="";
			// test du type de la ressource
			if(tagname=="D:resourcetype")
			{
				value = el.getElementsByTagName("D:collection").getLength()>0 ? "D" : "F";
				logger.debug("type : " + value);
			}
			else if(el.hasChildNodes())
				value=el.getFirstChild().getNodeValue();
			// Decode URL
			value =java.net.URLDecoder.decode(value);
			String mapname=tagname;
			String prefix="";
			if(tagname.indexOf(":")!=-1)
			{
				mapname=tagname.substring(tagname.indexOf(":")+1);
				prefix=tagname.substring(0,tagname.indexOf(":"));
			}
			//  publication validity 
			if(mapname.equals("document-state"))
			{
				published= value.equals("published");
			}
			if(mapname.equals("publication-date-begin"))
			{
				if(!value.equals(""))
					begin = value;
				
			}
			if(mapname.equals("publication-date-end"))
			{
				if(!value.equals(""))
					end = value;
			}
			attributes.addAttribute("", mapname, mapname, "CDATA", value  );
			String debugvalue = value.length()<=0 ? "none" : value.length()>30 ? value.substring(0, 29) : value;
			logger.debug("tagname : "+tagname+" mapname : "+mapname+" value : "+debugvalue);
			
		}
//	  publication validity checking
		checkdate = checkDate(begin, end);
		
		if(published && checkdate)
		{
			// 		resource element start
			super.contentHandler.startElement(URI, nodeName, PREFIX + ':' + nodeName, attributes);
			//		resource element end
			super.contentHandler.endElement(URI, nodeName, PREFIX + ':' + nodeName);
		}
		
	}catch(Exception se)
	{
		logger.error("WebdavGenerator::addFileProp Erreur de parsing element : "+value+"\n"+se.getMessage());
	}
}
    private boolean checkDate(String strbegin, String strend)
    {
    	Date now=new Date();
    	Date begin= parseDate(strbegin);
    	Date end=parseDate(strend);
    	boolean result=true;
    	if((begin!=null) && (end!=null))
		{
    		result = begin.before(now) && end.after(now);
    		logger.debug("begin date :"+begin.toGMTString()+"\nend date :"+end.toGMTString());
		}
		else if(begin!=null)
		{
			result = begin.before(now);
			logger.debug("begin date :"+begin.toGMTString());
		}
		else if(end!=null)
		{
			result = end.after(now);
			logger.debug("end date :"+end.toGMTString());
		}	
		return result;
    }
    private Date parseDate(String aDate)
    {
    	if(aDate.equals(""))
    		return null;
    	
    	Date result=null;
    	try
		{
        	String day=aDate.substring(0, aDate.indexOf('/'));
        	String monthyear =aDate.substring(aDate.indexOf('/')+1);
        	String month=monthyear.substring(0, aDate.indexOf('/'));
        	String year =aDate.substring(aDate.lastIndexOf('/')+1);
        	logger.debug("for "+aDate+" [day : "+day+"\tmonth : "+month+"\tyear : "+year+"]");
    		result=new Date(Integer.parseInt(year)-1900,Integer.parseInt(month)-1, Integer.parseInt(day));
		}
    	catch(Exception e)
		{
    		logger.error("bad date format(dd/mm/yyyy) :"+ aDate);
    		return null;
		}
    	return result;
    }
	/* (non-Javadoc)
	 * @see org.apache.cocoon.generation.Generator#generate()
	 */
	public void generate() throws IOException, SAXException,
			ProcessingException {
		try {
			this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping(PREFIX, URI);
            AttributesImpl attributes = new AttributesImpl();
        	// attribut identifiant la resource
        	attributes.addAttribute("","directory", "directory", "CDATA", directory  );
//        	dbut lment ressource
    		super.contentHandler.startElement(URI, ROOT_NODE_NAME, PREFIX + ':' + ROOT_NODE_NAME, attributes);
    		buildResponse();
//    		fin lment ressource
    		super.contentHandler.endElement(URI, ROOT_NODE_NAME, PREFIX + ':' + ROOT_NODE_NAME);
            
            this.contentHandler.endPrefixMapping(PREFIX);
            this.contentHandler.endDocument();
		}catch(Exception e)
		{
			StackTraceElement[] tab = e.getStackTrace();
			String ST="";
			for(int i=0;i<tab.length;i++)
			{
				ST+="\n"+tab[i].getFileName()+" l"+tab[i].getLineNumber()+" : "+ tab[i].getClassName()+"\t"+tab[i].getMethodName();
			
			}
			ST+="\n\nCause :"+e.getCause();
			logger.error("WebdavGenerator::generate : Soucis\n"+e.getMessage()+ST);
			
		}
		//webdavResource.closeSession();
		logger.debug("WebdavGenerator::generate : query on resource "+webdavpath+" ok.");
		
	}

	
	/**
	 * Connect to the WebDAV server	 
	 * @throws ServerException
	 */
	public void connect(String connexionString) throws Exception
	{
		logger.info("WebdavGenerator::connect try to connect webdavpath : "+webdavpath+"\nlogin : "+login);
		try 
		{
				if((login!=null) && (password!=null))
				{	
					webdavConnection.connect(connexionString, login, password);	
				}
				else
				{
					webdavConnection.connect(connexionString);	
				}
			}
		catch (Exception ex) 
		{	
			logger.error("error connecting to webdav resource : "+ connexionString+"\ncause : "+ex.getCause());	
	        throw ex;
	    }
		
		logger.info("WebdavGenerator::connect ---> OK");
	}

}
